#include "Config.h"

namespace Config
{
	namespace Game
	{
		extern int CompleteMapInformation		= 0;
		extern int UserInput					= 1;
		extern int GameSpeed					= 42;
		extern bool UseThread					= true;
	}
	namespace Protoss
	{
		extern double MineSpeed					= 0.03;			/* one probe mine speed per frame */
	}
	namespace StrategyManager
	{
		extern int FrequencyFrame				= 21;
		extern int SearchMaxDepth				= 30;
		extern int MinAttackNum					= 1;		// minimum attackers in each region
		extern int SearchFrequencyFrame			= 42 * 10; 
		extern int MinMineNum					= 2;
		extern int StepOneMinerNum = 7;
		extern int RegionCannonNum = 6;
		extern int GatewayNum = 4; 
		extern int GatewayLatestTime = 20*60*42;
		extern int BaseLocationMinMineral = 2000;
	}
	namespace InformationManager
	{
		extern int FrequencyFrame				= 21;
		extern int CannonEquivalentUnits		= 4;		// each cannon can attack how many units 
		extern int BaseLocationScoutFrame		= 42*60;
		extern int ScoutLargeTileRange			= 4;		// larger than 256/128 
		extern int RegionEnemyDefendRange = 32*4;
	}
	namespace BuildingManager
	{
		extern int FrequencyFrame				= 21;
		extern int PlanBuildingWaitFrame		= 42 * 20;
		extern int ConstructingEnemyRadius		= 32*4;
		extern int BaseBuildRadius				= 8*3;
		extern int BuildLocationSpace			= 2;
		extern int CannonGatherLimit = 8;
		extern int CannonGatherRange = 6;
	}
	namespace UnitProbeManager
	{
		extern int FrequencyFrame				= 5; 
		extern int MapUnAnalyzeScoutNum			= 0;
	}
	namespace UnitZealotManager
	{
		extern int FrequencyFrame = 5;
		extern int WeaponSumRange = 32 * 8;
		extern int GatherRange = 32 * 7; 
		extern int SmallSizeAttackLimit = 5;
		extern int MediumSizeAttackLimit = 9;
		extern int LargeSizeAttackLimit = 15;
		extern int UnknownSizeAttackLimit = 20;
		extern int EnemyCoverRange = 32*2;
	}
	namespace UnitProbeInterface
	{
		extern int FrequencyFrame				= UnitProbeManager::FrequencyFrame;
		extern int BuilderCloseDistance			= 2*32;			/* builder should first move close to build location less than this distance */
		extern int BuildNearMaxRange			= 6;			/* half sight range of probe, 256/2 */
		extern int BlockSpan					= 85;		// 64
		extern int BlockRadius					= 2;		// 3
		extern int EnemyReward					= -200; 
		extern int ObstacleReward				= -200; 
		extern int UnWalkableReward				= -200; 
		extern int TargetReward					= 200; 
		extern int MineralReward				= 100;
		extern int IterateTime					= 3;
	}
	namespace UnitZealotInterface
	{
		extern int FrequencyFrame = UnitZealotManager::FrequencyFrame;
	}
	namespace Debug
	{
		extern bool DrawAttack					= true;
		extern bool DrawMove					= true;
		extern bool DrawRightClick				= true;
		extern bool DrawAttackTarget			= true; 
		extern bool DrawBlocksRewards			= true;
		extern bool DrawPlanBuilding			= true; 
		extern bool DrawSearchBuild				= true;
		extern bool DrawTime					= true;
		extern bool DrawExtendedInterface = true;
	}
	namespace Timer
	{
		extern double TotalMicroSec = 50000;
		extern double InformationManagerMaxMicroSec = 10000;
		extern double StrategyManagerMaxMicroSec = 10000;
		extern double BuildingManagerMaxMicroSec = 10000;
		extern double UnitProbeInterfaceMaxMicroSec = 10000;
	}
}